//	MoveTurn-TextureWithLighting.vs

uniform mat4	uniModelViewProjectionMatrix;
uniform vec3	uniDiffuseEvaluator,
				uniSpecularEvaluator;

in vec3		atrPosition;		//	position of vertex in tile's local coordinates
in vec2		atrTexCoord;
in vec3		atrFaceNormal;
in vec4		atrFaceColor;		//	premultiplied alpha

in mat3		atrTilePlacement;

out vec2	varTextureCoordinates;
out vec4	varDiffuseColor,	//	premultiplied alpha
			varSpecularColor;	//	premultiplied alpha

void main()
{
	vec3	tmpPosition,		//	position of vertex in tiling coordinates
			tmpFaceNormal;		//	face normal in tiling coordinates
	float	tmpDiffuseFactor,
			tmpSpecularFactor;

	tmpPosition	= atrTilePlacement * atrPosition;
	gl_Position	= uniModelViewProjectionMatrix * vec4(tmpPosition, 1.0);

	varTextureCoordinates = atrTexCoord;
	
	tmpFaceNormal		= atrTilePlacement * atrFaceNormal;
	tmpDiffuseFactor	= 0.325  +  0.625 * max(0.0, dot(uniDiffuseEvaluator, tmpFaceNormal));
	tmpSpecularFactor	= 0.125 * pow(max(0.0, dot(uniSpecularEvaluator, tmpFaceNormal)), 64.0);
	varDiffuseColor		= vec4(	tmpDiffuseFactor * atrFaceColor.r,
								tmpDiffuseFactor * atrFaceColor.g,
								tmpDiffuseFactor * atrFaceColor.b,
								1.0              * atrFaceColor.a);
	varSpecularColor	= vec4(tmpSpecularFactor, tmpSpecularFactor, tmpSpecularFactor, tmpSpecularFactor);
}
